﻿/* Функция loadDNATextures() зарежда текстури на четирите
	нуклеобази, като използва картинки кодирани като Data URL */
	
function loadDNATextures()
{
	// текстура на аденин
	texA = new Suica.Image('data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/bAIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBAQEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUwMDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAQAAgAwEiAAIRAQMRAf/EAHQAAQACAwEAAAAAAAAAAAAAAAAGBwMEBQIBAQACAwAAAAAAAAAAAAAAAAACBAEDBRAAAgAFAwMEAwEAAAAAAAAAAQIAEgMEBRETBiExFEFRIpKBMiNyEQACAgEEAwAAAAAAAAAAAAABAgADESExEgQiMhP/2gAMAwEAAhEDEQA/AJZtw242ZBCQRwOcj8ZrbcNuNmQQkEOcfGeoQhEJYiEIQiIjPI+aU8HfLZLa+U8gdzubcsxOi/o2vQaxJXdKaNUcyogLMx7ADqTFO16lXkHISw11vq4VfdUJlX6rFrqUrYzFxlEXWRY42k947zWlm742T2vivIXpnc3Jivdf0T06xJopui9bAZ8MdS9jXKt7sqmVvssXFTqJVprUpmZHAZWHYgjUGHbpWtlKDCOukKc7zgc5yXgYKrTQ6Vbw7C/5brUP16fmK6wOUp4jJU796HkmkGkpzyfJhLNrK3ofaJhzXC8gzF/SFla7lpbpojblNdXfq50dwfQDtGTjvBbMWBOdtJrxnYhd1hKmgCj+NSU+pjfS9NXXw5DGz2VT5azBBJkKzuUp5fJVL9KHjGqFnpzz/JRLNrKvcD2ixOCZLzsElFzrVsjst7yd6Z+vT8Rz+R8FtDYq2CtZbtXEy7rGZCCCP7VJRodDGLheE5Dh8lU8y1NOzuElqNuU2lZfkjaI5PuO3rC56bevhCF4eqsfLSACDP/Z');

	// текстура на тимин
	texT = new Suica.Image('data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/bAIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBAQEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUwMDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAQAAgAwEiAAIRAQMRAf/EAHgAAQEBAQEAAAAAAAAAAAAAAAAGBAUCAQEAAgMAAAAAAAAAAAAAAAAAAgMBBAUQAAAEBQMBBwUAAAAAAAAAAAABAhIRAxMEBVEiMgZxYsKj42QVQlIjFBYRAQACAQQBBQAAAAAAAAAAAAEAAgMRIUESMVFxsRME/9oADAMBAAIRAxEAPwClqBUGV5g8xyek5n3TVUCoMrzB5h0j7p4AAE5RAAARORnc98OckqFesSj5sg1vdVqOV/dex870xQ32KsMiaDvJVU5cWblJg6EeCi0El1Xi7HHKtSs5VIphLfuUqLWw5meovxGK2lWr29eJtYDBbrS1Vu678fM2f3XsfO9MdbBZ35iv+ChQZ9b3Pd3U/aJ/pTFWGRTdHeSqpyzQzcpMHOjwUWgq7DFWGOqfpyqVWD9ylRbGHMz1DKYq61KpY54jOYK9qVqlzTfj5msSXXXOy7JvgFaJ3qvFX+RVanZyqpSyW/clMHNhzUWghhQyCunmV/mQy1VA33faZ+heF72yvGKoT/SmLvscm6K8lUjmGhm5KotdHgZ6igDMjksjr4mP0I5bIibbntP/2Q==');

	// текстура на гуанин
	texG = new Suica.Image('data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/bAIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBAQEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUwMDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAQAAgAwEiAAIRAQMRAf/EAH8AAAMBAAMAAAAAAAAAAAAAAAADBAUBAgYBAAMBAQAAAAAAAAAAAAAAAAACAwQFEAACAQMDAwAGCwAAAAAAAAABAgMAEQQSBQYhMVFBYXGRshOBobEiMkIjQ3MUNBEAAgIBAwMFAAAAAAAAAAAAAQIAAxExEgQhYRNRsdFSFP/aAAwDAQACEQMRAD8Av1UaqVqo1VPzzrfjjdVGqlaqNVHnh+OcUUUVnm6FFFFEJ0mmigjaWZgkaC7MewrDyOW4yMRjwNKAfxMQgPs6Mam5ZluZosNTZFX5jjySSBf2WpfH9lgzY3ycq7RhtCRg2uR1JJHX01VUULuaYbeRc13howCNWMqj5fEW/VxWVfKuGPuKrW7jZUGXCs8Da427H1+DWLn8VhkZGwWEI/cVyzC3le5+urdm2mTbFkVp/miSx06dIVh3t1NK2zGV6H0j0nlCzbaA6/cYHxMTlkLLnxzflkjAB9ak3+0VbxXNh/rPiMwWVXLKp6alYDt9Na247fBuGOYZehHVHHdW815efjG6RtaJVmX0FWC+8PamBVk2k4xI2V208g3VobFbUDvrEbltebjySzzRhIy5IOtCSGbp90NereJf75f4T8S0iHjO6yNZ0WIeWYH4NVeh2nZYNtBcMZJ3GlnPQW72UUzuNpGQT2k+Px7Detmxq1U5O89fYT//2Q==');

	// текстура на цитозин
	texC = new Suica.Image('data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/bAIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBAQEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUwMDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAQAAgAwEiAAIRAQMRAf/EAHgAAAMBAQEAAAAAAAAAAAAAAAAFBgMBAgEAAwEBAAAAAAAAAAAAAAAAAAIEAQMQAAIBAwIFAgQHAAAAAAAAAAECAwARBBIFITFBoQZhE1FxIjKRsdFCsiMUEQACAgICAgMAAAAAAAAAAAABAgADURIRE1IUMWGR/9oADAMBAAIRAxEAPwBlpo01rajTVvTJPcmWmjTWumjTR0w9ydoooqiQQoooohOO6RozuwVFF2Y8AAOpqdy/NMGJymLC2Rb95PtqflcMe1efNcx48WDEQ2E7FpLdVS1h+J7Un8Z2WHdJpXybmCALdAbama9hf4cKnstffrT5zKqqU6zbZyRgRtj+cYzvbIxXiUn7kYSdiEqjgyIcmFZ4HEkTi6sORqa3jxCNlR9pTS97SRM506bfcC5Jph45tOdtcMkWTKjpIQyohJ0N14kDnW1m0Nq45HkItq0lNqzqfExb5xCxXEnA+hS6MfgTpI/I1l4VmQxyZGLIwWSXQ0QJtq06gQPXjVTm4UGdjPi5AvG46cwehHqKjcvw7dInP+bTkR3+khgjW9Q9h3pbEdbexRt9TpU6PSanbTBP7KPft8Taok9vTJkOw/qJ5LzJNuXpRsm/Ju/uKIGieIAubhk4ngL8D2qXg8R3qR9MkawL1Z3U/wAC1WG0bVDtWIMeI62J1SSHgWb9KZGtZ+SNEwYli0pXwDu+RP/Z');

	texA.char = 'A';
	texT.char = 'T';
	texG.char = 'G';
	texC.char = 'C';
}

// два помощни масива за връзка от аминокиселина към кодон
// и от кодон към аминокиселина
acid = [];
codon = [];

function learn(theAcid,theCodons)
{
	for (var i=0; i<theCodons.length; i++)
	{
		acid[theAcid] = theCodons;
		codon[theCodons[i]] = theAcid;
	}
}

learn('Ala',['GCT', 'GCC', 'GCA', 'GCG']);
learn('Arg',['CGT', 'CGC', 'CGA', 'CGG', 'AGA', 'AGG']);
learn('Asn',['AAT', 'AAC']);
learn('Asp',['GAT', 'GAC']);
learn('Cys',['TGT', 'TGC']);
learn('Gln',['CAA', 'CAG']);
learn('Glu',['GAA', 'GAG']);
learn('Gly',['GGT', 'GGC', 'GGA', 'GGG']);
learn('His',['CAT', 'CAC']);
learn('Ile',['ATT', 'ATC', 'ATA']);
learn('Leu',['TTA', 'TTG', 'CTT', 'CTC', 'CTA', 'CTG']);
learn('Lys',['AAA', 'AAG']);
learn('Met',['ATG']);
learn('Phe',['TTT', 'TTC']);
learn('Pro',['CCT', 'CCC', 'CCA', 'CCG']);
learn('Ser',['TCT', 'TCC', 'TCA', 'TCG', 'AGT', 'AGC']);
learn('Thr',['ACT', 'ACC', 'ACA', 'ACG']);
learn('Trp',['TGG']);
learn('Tyr',['TAT', 'TAC']);
learn('Val',['GTT', 'GTC', 'GTA', 'GTG']);
